#pragma once
#include <QObject>

class QDateTime;
class QTimer;

class DateTime : public QObject {
    Q_OBJECT
    Q_PROPERTY(QString currentTime READ currentTime WRITE setCurrentTime NOTIFY currentTimeChanged)
    Q_PROPERTY(QString currentDate READ currentDate WRITE setCurrentDate NOTIFY currentDateChanged)
    Q_PROPERTY(int utcOffset READ utcOffset WRITE setUtcOffset NOTIFY utcOffsetChanged)
public:
    explicit DateTime(QObject* parent = nullptr);
    QString currentTime() { return m_currentTime; }
    QString currentDate() { return m_currentDate; }
    int utcOffset() { return m_utcOffset; }
    void setUtcOffset(int offset);

signals:
    void currentTimeChanged();
    void currentDateChanged();
    void utcOffsetChanged();

private:
    void setCurrentTime(const QString& currentTime);
    void setCurrentDate(const QString& currentDate);
    QDateTime* m_dateTime = nullptr;
    QTimer* m_timer = nullptr;
    QString m_currentTime;
    QString m_currentDate;
    int m_utcOffset = 0;
};
